//================================================================================================================================================\\
//================================================================================================================================================\\
//================================================================================================================================================\\
//                                                                 Tile Movement                                                                  \\
//                                                                    System                                                                      \\
//                                                                                                                                                \\
//================================================================================================================================================\\
//================================================================================================================================================\\
//================================================================================================================================================\\

var tileMovement = new tileMove(); // Create new instance of tile movement object

function createPerson(name, sprite, destroy)
{
  //CreatePerson
}

function tileMove() // Main Object
{
  this.firstUse = true;
  
  this.player = undefined; // Person that our input system will be controlling 
  
  this.talkButton = control.buttonA; // Sets our talk activation button, this way I can allow the player to choose what button they want to use
  
  this.talkHeld = false;
  
  this.personList = []; // New array for the person list
  
  this.movementObject = function(command1, command2, face)
  {
    this.command = command1; // Movement 1
    this.command2 = command2; // Movement 2 - for diagonals
    this.face = face; // Direction to face
  }
  
  // Movement objects - these are referred to later
  {
    this.north = new this.movementObject(COMMAND_MOVE_NORTH, undefined, "north");
    this.east = new this.movementObject(COMMAND_MOVE_EAST, undefined, "east");
    this.west = new this.movementObject(COMMAND_MOVE_WEST, undefined, "west");
    this.south = new this.movementObject(COMMAND_MOVE_SOUTH, undefined, "south");
    this.northEast = new this.movementObject(COMMAND_MOVE_EAST, COMMAND_MOVE_NORTH, "east");
    this.northWest = new this.movementObject(COMMAND_MOVE_WEST, COMMAND_MOVE_NORTH, "west");
    this.southEast = new this.movementObject(COMMAND_MOVE_EAST, COMMAND_MOVE_SOUTH, "east");
    this.southWest = new this.movementObject(COMMAND_MOVE_WEST, COMMAND_MOVE_SOUTH, "west");
    this.wait = new this.movementObject(COMMAND_WAIT, undefined, undefined);
  }
  
  this.personObject = function(person, canMove, waitToMove, maxWaitTime)
  {
    this.array = new Array(); // New movement array for the person
    this.tileIdX = Math.floor(GetPersonX(person) / GetTileWidth()) // Tile x id
    this.tileIdY = Math.floor(GetPersonY(person) / GetTileHeight()); // Tile y id
    this.tileIdX2 = this.tileIdX; // Next tile id will be the same as the current as no moves have been planned yet
    this.tileIdY2 = this.tileIdY; // Next tile id will be the same as the current as no moves have been planned yet
    this.canMove = canMove || true; // If person isnt obstructed, used later
    this.waitToMove = waitToMove || false; // True if you want the person to wait until the obstruction moves out of the way, and then the person will continue with his move
    this.waitTime = 0; // Used later if person gets blocked
    this.maxWaitTime = maxWaitTime || 5000; // Max amount of time person will wait before changing its move
    this.ignoringObstructions = false; // True if ignore all obstructions
  }
}

tileMove.prototype.grabPersonList = function() // To grab the personList arrays
{
  this.personList = []; // New array for the person list
  var list = GetPersonList();
  for (var i = 0; i < list.length; i++)
  {
    this.personList[list[i]] = new this.personObject(list[i]);
    SetPersonFrameRevert(list[i], 5); // Set the revert to frame 0 delay
  }
  this.firstUse = false;
}

tileMove.prototype.ignoreObstructions = function(person, pass) // To turn on ignore obstructions
{
  this.personList[person].ignoringObstructions = pass;
  IgnoreTileObstructions(person, pass);
  IgnorePersonObstructions(person, pass);   
}

tileMove.prototype.attachInput = function(person) { this.player = person; }

// Attachs the input to the specified person
tileMove.prototype.detachInput = function() { this.player = undefined; }

// Detachs the input completly
tileMove.prototype.handleInput = function() // To handle users input
{
  if (this.player && this.personList[this.player].array.length == 0) // If player has no moves planned
  {
    if (IsKeyPressed(control.buttonUp))  
    {
      if (!this.checkObstruction(this.player, 10)) return this.addMove(this.player, "n"); // Assign movement to the movement queue
      SetPersonDirection(this.player, "north");
      return this.handlePersonScript(GetPersonDirection(this.player), SCRIPT_ON_ACTIVATE_TOUCH); 
    }
    // Check if we tried to move into a person
    if (IsKeyPressed(control.buttonRight))  
    {
      if (!this.checkObstruction(this.player, 11)) return this.addMove(this.player, "e"); // Assign movement to the movement queue
      SetPersonDirection(this.player, "east"); // If cant move then face that direction
      return this.handlePersonScript(GetPersonDirection(this.player), SCRIPT_ON_ACTIVATE_TOUCH); 
    }
    // Check if we tried to move into a person
    if (IsKeyPressed(control.buttonDown))  
    {
      if (!this.checkObstruction(this.player, 12)) return this.addMove(this.player, "s"); // Assign movement to the movement queue
      SetPersonDirection(this.player, "south"); // If cant move then face that direction
      return this.handlePersonScript(GetPersonDirection(this.player), SCRIPT_ON_ACTIVATE_TOUCH); 
    }
    // Check if we tried to move into a person
    if (IsKeyPressed(control.buttonLeft)) 
    {
      if (!this.checkObstruction(this.player, 13)) return this.addMove(this.player, "w"); // Assign movement to the movement queue
      SetPersonDirection(this.player, "west"); // If cant move then face that direction
      return this.handlePersonScript(GetPersonDirection(this.player), SCRIPT_ON_ACTIVATE_TOUCH); 
    }
    // Check if we tried to move into a person
    if (IsKeyPressed(this.talkButton) && !this.talkHeld)   
    {
      // If we press talk activation button
      this.handlePersonScript(GetPersonDirection(this.player), SCRIPT_ON_ACTIVATE_TALK); 
      return this.talkHeld = true 
    }
    // Handle the talk activation
    if (!IsKeyPressed(this.talkButton)) this.talkHeld = false; // After talk key is released allow for it again
  }
}

tileMove.prototype.handlePersonScript = function(dir, script) // To handle person script activation
{
  if (dir == "north" && this.isPersonAt(this.personList[this.player].tileIdX, this.personList[this.player].tileIdY - 1)) // Check person to the north
  {
    return CallPersonScript(this.isPersonAt(this.personList[this.player].tileIdX, this.personList[this.player].tileIdY - 1), script);   
  }
  if (dir == "east" && this.isPersonAt(this.personList[this.player].tileIdX + 1, this.personList[this.player].tileIdY))
  {
    return CallPersonScript(this.isPersonAt(this.personList[this.player].tileIdX + 1, this.personList[this.player].tileIdY), script);   
  }
  if (dir == "south" && this.isPersonAt(this.personList[this.player].tileIdX, this.personList[this.player].tileIdY + 1))
  {
    return CallPersonScript(this.isPersonAt(this.personList[this.player].tileIdX, this.personList[this.player].tileIdY + 1), script);   
  }
  if (dir == "west" && this.isPersonAt(this.personList[this.player].tileIdX - 1, this.personList[this.player].tileIdY))
  {
    return CallPersonScript(this.isPersonAt(this.personList[this.player].tileIdX - 1, this.personList[this.player].tileIdY), script);   
  }
}

tileMove.prototype.checkObstruction = function(person, dir) // To check for tile obstructions
{
  this.PX = GetPersonX(person);
  this.PY = GetPersonY(person);
  var i = 0
  var X = 0
  var Y = 0
  switch (dir)
  {
    case 10: // Check for obstructions to the north, this is only called once before the move
    {
      i = GetTileHeight(); // Needed to check for different height/width tiles
      X = 0 // 0 because we are not checking horizontally
      Y = -1 // -1 because we are checking upwards
      break;
    }
    case 12: // Check for obstructions to the south, this is only called once before the move
    {
      i = GetTileHeight(); // Needed to check for different height/width tiles
      X = 0 // 0 because we are not checking horizontally
      Y = +1 // +1 because we are checking downwards
      break;
    }
    case 13: // Check for obstructions to the west, this is only called once before the move
    {
      i = GetTileWidth(); // Needed to check for different height/width tiles
      X = -1 // -1 because we are checking to the left
      Y = 0 // 0 because we are not checking vertically
      break;
    }
    case 11: // Check for obstructions to the east, this is only called once before the move
    {
      i = GetTileWidth(); // Needed to check for different height/width tiles
      X = +1 // +1 because we are checking to the right
      Y = 0 // 0 because we are not checking vertically
      break;
    }
  }
  if(IsPersonObstructed(person, this.PX + i*X, this.PY + i*Y)) return true;
  i = i >> 1;
  if(IsPersonObstructed(person, this.PX + i*X, this.PY + i*Y)) return true;
  if (this.personList[person].tileIdX2 != -1 && this.personList[person].tileIdX2 < GetLayerWidth(GetPersonLayer(person))
  && this.personList[person].tileIdY2 != -1 && this.personList[person].tileIdY2 < GetLayerHeight(GetPersonLayer(person))) return false; // If person is NOT going off the map return false
  else return true; // If the person IS moving off the map return obstructed
}

tileMove.prototype.personCanMove = function(person) // To establish if a person will end up obstructing or being obstructed by another person
{
  var list = GetPersonList(); // Grab the person list
  for (var i = 0; i < list.length; i++)
  {
    if (this.personList[person].tileIdX2 == this.personList[list[i]].tileIdX && this.personList[person].tileIdY2 == this.personList[list[i]].tileIdY 
    && list[i] != person  && !this.personList[person].ignoringObstructions) return false; // return false if we are going to collide with a person if we move
    if (this.personList[person].tileIdX2 == this.personList[list[i]].tileIdX2 && this.personList[person].tileIdY2 == this.personList[list[i]].tileIdY2 
    && list[i] != person  && !this.personList[person].ignoringObstructions) return false; // return false if we are going to collide with a person if we move
  }
  return true; // If not person can move so we return true
}

tileMove.prototype.isPersonAt = function(x, y) // To check if someone is at x,y (x, y is by tile id not pixels)
{
  var list = GetPersonList(); // Grab list of all persons on the map
  for (var i = 0; i < list.length; i++) // Now we check if they are next to the player and if the player is facing them
  {
    if (list[i] != this.player && this.personList[list[i]].tileIdX == x && this.personList[list[i]].tileIdY == y) // If this person is on the tile that the Player is trying to interact with
    {
      return list[i]; 
    }
    // Return the person's name that is on that tile
  }
  return undefined; // If no-one is on the tile we return undefined
}

tileMove.prototype.addMove = function(person, dir) // To add a move to the persons movement queue
{
  switch (dir) // Handle via the direction that was passed
  {
    case "n": // Handle north movement
    {
      var temp = this.north; // Use north object
      break; // break from this check
    }
    case "e": // Handle east movement
    {
      var temp = this.east; // Use east object
      break; // break from this check
    }
    case "w": // Handle west movement
    {
      var temp = this.west; // Use west object
      break; // break from this check
    }
    case "s": // Handle south movement
    {
      var temp = this.south; // Use south object
      break; // break from this check
    }
    case "ne": // Handle north east movement
    {
      var temp = this.northEast; // Use north east object
      break; // break from this check
    }
    case "se": // Handle south east movement
    {
      var temp = this.southEast; // Use south east object
      break; // break from this check
    }
    case "sw":// Handle south west movement
    {
      var temp = this.southWest; // Use south west object
      break; // break from this check
    }
    case "nw": // Handle north west movement
    {
      var temp = this.northWest; // Use north west object
      break; // break from this check
    }
    case "wait": // Handle wait
    {
      var temp = this.wait; // Use wait object
      break; // break from this check
    }
  }
  var movement = new Object; // Create a movement object to store our movements in
  movement.face = temp.face; // Direction that we will face
  movement.command = temp.command; // Direction that we will move
  movement.command2 = temp.command2; // Second command for other directions
  if (dir != "n" && dir != "s") 
  {
    // Check if the next move is horizontal
    movement.pixels = GetTileWidth() / GetPersonSpeedX(person); // Get horizontal tile size
    movement.tilePixels = movement.pixels; 
  }
  // We need this to know if the person has begun to move or not - handles different tile sizes
  else if (dir == "wait") movement.pixels = GetMapEngineFrameRate(); // To handle if the move is "wait"
  else 
  {
    movement.pixels = GetTileHeight() / GetPersonSpeedY(person); // Otherwise grab the vertical tile size
    movement.tilePixels = movement.pixels; 
  }
  // We need this to know if the person has begun to move or not - handles different tile sizes
  this.personList[person].array[this.personList[person].array.length] = movement; // Add our movement to the person's move queue
}

tileMove.prototype.planRandomMove = function(person, freq) // Random move generator
{
  if (this.personList[person]) // if we are moving a person - needed if used on persons on a map rather than creating them as it has to recalculate the personList. Can cause an error otherwise
  {
    var randomNumber = Math.floor(Math.random() * freq) // Random number
    switch (randomNumber)
    {
      case Math.floor(freq / 4): // Random north
      {
        return this.addMove(person, "n"); // Move person north
      }
      case Math.floor(freq / 4 * 2): // Random east
      {
        return this.addMove(person, "e"); // Move person east
      }
      case Math.floor(freq / 4 * 3): // Random south
      {
        return this.addMove(person, "s"); // Move person south
      }
      case Math.floor(freq - 1): // Random west
      {
        return this.addMove(person, "w"); // Move person west
      }
    }
    return this.addMove(person, "wait"); // If random number equals none of the above then wait for one second;
  }
}

tileMove.prototype.nextTile = function(person, id) // This is to work out what tile our person is moving to
{
  switch (id)
  {
    case 10:
    {
      if (this.personList[person].array[0].pixels == (GetTileHeight() / GetPersonSpeedY(person))) return this.personList[person].tileIdY2 = this.personList[person].tileIdY - 1; // If our person hasnt started to move return the new tile id 
      break;
    }
    case 11:
    { 
      if (this.personList[person].array[0].pixels == (GetTileWidth() / GetPersonSpeedX(person))) return this.personList[person].tileIdX2 = this.personList[person].tileIdX + 1; // If our person hasnt started to move return the new tile id 
      break;
    }
    case 12:
    { 
      if (this.personList[person].array[0].pixels == (GetTileHeight() / GetPersonSpeedY(person))) return this.personList[person].tileIdY2 = this.personList[person].tileIdY + 1 // If our person hasnt started to move return the new tile id 
      break;
    }
    case 13:
    { 
      if (this.personList[person].array[0].pixels == (GetTileWidth() / GetPersonSpeedX(person))) return this.personList[person].tileIdX2 = this.personList[person].tileIdX - 1; // If our person hasnt started to move return the new tile id 
      break;
    } 
  }
}

tileMove.prototype.moveStairs = function(dir) // To handle moving up and down stairs
{
  switch(dir) 
  {
    case "se": 
    {
      if (IsKeyPressed(KEY_RIGHT) && IsCommandQueueEmpty(this.player)) 
      {
        IgnoreTileObstructions(this.player, true);
        return this.addMove(this.player, "se"); 
      }
      break; 
    }
    case "sw": 
    {
      if (IsKeyPressed(KEY_LEFT) && IsCommandQueueEmpty(this.player)) 
      {
        IgnoreTileObstructions(this.player, true);
        return this.addMove(this.player, "sw"); 
      }
      break; 
    }
    case "ne": 
    {
      if (IsKeyPressed(KEY_RIGHT) && IsCommandQueueEmpty(this.player)) 
      {
        IgnoreTileObstructions(this.player, true);
        return this.addMove(this.player, "ne"); 
      }
      break; 
    }
    case "nw": 
    {
      if (IsKeyPressed(KEY_LEFT) && IsCommandQueueEmpty(this.player)) 
      {
        IgnoreTileObstructions(this.player, true);
        return this.addMove(this.player, "nw"); 
      }
      break; 
    }
  }
}

tileMove.prototype.handleTile = function()
{
  // Zone handling
  if (this.player && AreZonesAt(GetPersonX(this.player), GetPersonY(this.player), GetPersonLayer(this.player))) 
  { ExecuteZones(GetPersonX(this.player), GetPersonY(this.player), GetPersonLayer(this.player)); } // If we are inside a zone then execute it
  // Trigger handling
  if (this.player && IsTriggerAt(GetPersonX(this.player), GetPersonY(this.player), GetPersonLayer(this.player)) && this.personList[this.player].array.length == 0) 
  { ExecuteTrigger(GetPersonX(this.player), GetPersonY(this.player), GetPersonLayer(this.player)); } // If we are inside a trigger then execute it 
}

tileMove.prototype.handleMove = function(person) // To handle moving our sprite
{
  // Movement handling
  if (this.personList[person].array.length > 0 && this.personList[person].array[0].pixels > 0) // If person has a move to perform
  {
    this.nextTile(person, this.personList[person].array[0].command); // Calculate what tile the person will land on after the move
    if (this.personList[person].array[0].pixels == this.personList[person].array[0].tilePixels && this.personCanMove(person) && !this.checkObstruction(person, this.personList[person].array[0].command))
    {
      this.personList[person].canMove = true; // Set person as able to perform they're move
      if (this.personList[person].array[0].face) SetPersonDirection(person, this.personList[person].array[0].face); // To make sure sprite is facing the correct way
      for (var i = this.personList[person].array[0].pixels; i > 0; i--) // For every pixel the person will need to travel 
      {
        QueuePersonCommand(person, this.personList[person].array[0].command, false); // Moves sprite in the appropriate direction
        if (this.personList[person].array[0].command2) QueuePersonCommand(person, this.personList[person].array[0].command2, true); // Moves sprite in the appropriate direction
      }
    }
    else if (this.personList[person].array[0].pixels == this.personList[person].array[0].tilePixels) // If either blocked by tile obstruction or because they were interfering with another persons move
    {
      if (this.personList[person].array[0].face) SetPersonDirection(person, this.personList[person].array[0].face); // To make sure sprite is facing the correct way
      if (this.personList[person].waitToMove == true) // If person is set tp wait till the obstruction moves out of the way and then continue with his move
      {
        if (this.personList[person].waitTime == 0) this.personList[person].waitTime = GetTime() + this.personList[person].maxWaitTime; // If this is the first instance of obstruction and the person is set to re-calculate after x amount of time
        else if (GetTime() >= this.personList[person].waitTime && !this.personList[person].waitToMove) this.personList[person].array[0].pixels = 0; // If we have reached the ammount of time that person will wait, then abandon move
        this.personList[person].canMove = false; // Set can move to false so his pixels to travel count does not decrease
      }
      else 
      {
        this.personList[person].canMove = true; 
      }
      // Other-wise let it decrease so that we move on to the next move
    }
    if (this.personList[person].canMove) // If person is able to move or set to ignore moves that cannot be performed
    {
      if (this.personList[person].waitTime != 0) this.personList[person].waitTime = 0; // If the person was obstructed and then managed to move then reset the counter
      this.personList[person].array[0].pixels--; // Reduce 1 from the pixels we still need to travel
    }
    if (this.personList[person].array[0].pixels == 0) // If pixels to travel is 0
    {
      if (person == this.player) { steps++ }; // For step count in main menu
      this.personList[person].tileIdX = Math.floor(GetPersonX(person) / GetTileWidth()); // Get Current tile x id
      this.personList[person].tileIdY = Math.floor(GetPersonY(person) / GetTileHeight()); // Get Current tile y id
      this.personList[person].tileIdY2 = this.personList[person].tileIdY; // Reset back to current tile
      this.personList[person].tileIdX2 = this.personList[person].tileIdX; // Reset back to current tile
      if (!this.personList[person].ignoringObstructions && IsIgnoringTileObstructions(person)) IgnoreTileObstructions(person, false); // If person is not supposed to be ignoring obstructions
      this.personList[person].array.splice(0, 1); // Remove that last move from the array 
    }
  }
}

tileMove.prototype.renderInfo = function() // JUST FOR MY TESTING - NOT NEEDED FOR SYSTEM
{
  var list = GetPersonList()
  for (var i = 0; i < list.length; i++)
  {
    //OutlinedRectangle(camera.mapToScreenX(this.personList[list[i]].tileIdX * GetTileWidth()), camera.mapToScreenY(this.personList[list[i]].tileIdY * GetTileHeight()), 
    //GetTileWidth(), GetTileHeight(), CreateColor(255, 0, 0, 255));
    
    //OutlinedRectangle(camera.mapToScreenX(this.personList[list[i]].tileIdX2 * GetTileWidth()), camera.mapToScreenY(this.personList[list[i]].tileIdY2 * GetTileHeight()), 
    //GetTileWidth(), GetTileHeight(), CreateColor(0, 0, 255, 255));
  }
}

tileMove.prototype.update = function() // To update movement and input
{
    if (!this.firstUse) 
    {
      var list = GetPersonList(); // Grab list of all persons on the map
      for (var i = 0; i < list.length; i++) // Hmm... This will at least loop through all the people on the map, although there are other ways
      {
        this.handleMove(list[i]); // Handles the sprite movement
      }
      this.handleTile();
      this.handleInput(); // Handles the key-press
    }
    else
    {
      this.grabPersonList(); // This is to grab the person List if this is the first time this has been used
    }
}

